<?php
include 'db.php'; // Database connection

// Check if 'id' is provided
if(!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: blog.php"); // Redirect if no id
    exit;
}

$post_id = intval($_GET['id']);

// Fetch post details with category
$sql = "SELECT p.*, c.name AS category_name 
        FROM posts p
        JOIN categories c ON p.category_id = c.id
        WHERE p.id = $post_id";
$result = $conn->query($sql);

if(!$result || $result->num_rows == 0) {
    echo "Post not found.";
    exit;
}

$post = $result->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($post['title']); ?> – Wonder Lanka</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
* { margin:0; padding:0; box-sizing:border-box; }
body { font-family: 'Poppins', sans-serif; background: #fafafa; color:#222; line-height:1.7; }
a { text-decoration:none; color:inherit; }
header {
  position: sticky; top:0; z-index:1000; background:#fff; display:flex;
  justify-content:space-between; align-items:center; padding:15px 8%;
  box-shadow:0 2px 8px rgba(0,0,0,0.05);
}
header h1 { color:#00897b; font-size:1.8em; font-weight:700; }
nav a { margin:0 14px; font-weight:500; color:#333; }
nav a:hover { color:#00897b; }

.hero {
  height: 30vh; background: url('<?php echo $post['image']; ?>') center/cover no-repeat;
  display:flex; align-items:center; justify-content:center; color:#fff; position:relative;
}
.hero::after { content:''; position:absolute; inset:0; background:rgba(0,0,0,0.5); }
.hero h1 { position:relative; font-size:2.5em; text-align:center; }

.post-container { padding:50px 8%; max-width:900px; margin:auto; background:#fff; border-radius:15px; box-shadow:0 5px 15px rgba(0,0,0,0.1); }
.post-container h4 { color:#00897b; margin-bottom:10px; }
.post-container h2 { color:#004d40; margin-bottom:15px; }
.post-container .meta { font-size:0.9em; color:#555; margin-bottom:20px; }
.post-container img { width:100%; height:auto; border-radius:10px; margin-bottom:20px; }
.post-container p { margin-bottom:15px; }

/* Footer */
footer { background:#004d40; color:#e0f2f1; text-align:center; padding:50px 8%; font-size:0.95em; }
footer a { color:#80cbc4; text-decoration:none; margin:0 10px; }
footer a:hover { color:#fff; }
</style>
</head>
<body>

<!-- Header -->
<header>
  <h1>Wonder Lanka</h1>
  <nav>
  
    <a href="index.html">Home</a> | 
    <a href="discover.php">Discover</a> | 
    <a href="blog.php">Blog</a> | 
    <a href="about.php">About</a> | 
    <a href="contact.php">Contact</a>
  </nav>
</header>

<!-- Hero -->
<section class="hero">
  <h1><?php echo htmlspecialchars($post['title']); ?></h1>
</section>

<!-- Post Content -->
<section class="post-container">
  <h4><?php echo htmlspecialchars($post['category_name']); ?></h4>
  <h2><?php echo htmlspecialchars($post['title']); ?></h2>
  <div class="meta">
    By <?php echo htmlspecialchars($post['author']); ?> | <?php echo date('d M Y', strtotime($post['created_at'])); ?>
  </div>
  <img src="<?php echo $post['image']; ?>" alt="<?php echo htmlspecialchars($post['title']); ?>">
  <p><?php echo nl2br($post['content']); ?></p>
</section>

<!-- Footer -->
<footer>
  <p>
   
    <a href="index.html">Home</a> | 
    <a href="discover.php">Discover</a> | 
    <a href="blog.php">Blog</a> | 
    <a href="about.php">About</a> | 
    <a href="contact.php">Contact</a>
  </p>
  <p>© 2025 Wonder Lanka. All Rights Reserved.</p>
</footer>

</body>
</html>
