<?php
// db.php content
$servername = "localhost";
$username = "root"; // update if needed
$password = "";
$dbname   = "flora_db";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Database Connection Failed: " . $conn->connect_error);
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Flora - Fresh Flowers</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        /* Navbar */
        nav {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background: #6b0f9cff;
            padding: 10px 20px;
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        nav .logo {
            display: flex;
            align-items: center;
            gap: 80px;
            color: #fce4f0ff;
            font-size: 40px;
            font-weight: bold;
            font-family:'cursive';
        }
        nav .logo img {
            height: 40px;
            width: auto;
            border-radius: 60%;
            border: 2px solid #fce4f0ff;
        }
        nav ul {
            display: flex;
            list-style: none;
            gap: 25px;
        }
        nav ul li a {
            color: #ffd6f3ff;
            font-size: 20px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 5px;
            transition: color 0.3s ease;
        }
        nav ul li a:hover {
            color: #ffe0fb;
        }
        .hidden-label {
            position: absolute;
            left: -9999px;
            top: auto;
            width: 1px;
            height: 1px;
            overflow: hidden;
        }
        /* Hero */
        .hero {
            background: linear-gradient(to right, #ffd1dc, #ffa6f1);
            text-align: center;
            padding: 100px 20px;
            color: #4b004b;
        }
        .hero h1 { font-size: 3rem; }
        .hero p { font-size: 1.3rem; margin:10px 0 20px; }
        .shop-btn {
            background: #4b004b;
            color: #fff;
            padding: 15px 25px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: bold;
        }
        .shop-btn:hover { background: #72007aff; }
        /* Product Grid */
        .flower-products { padding:50px 20px; background:#fff0f6; text-align:center; }
        .products-grid { display:flex; flex-wrap:wrap; justify-content:center; gap:20px; }
        .product-card {
            background:#fff;
            padding:20px;
            border-radius:12px;
            flex:1 1 250px;
            box-shadow:0px 4px 10px rgba(0,0,0,0.1);
            text-align:center;
        }
        .product-card img { width:100%; height:200px; object-fit:cover; border-radius:8px; }
        .product-card h3 { color:#6b0f9c; margin:10px 0; }
        .product-card .price { font-weight:bold; color:#ff66aa; }
        .product-card .btn {
            display:inline-block;
            margin-top:10px;
            padding:10px 15px;
            background:#6b0f9c;
            color:#fff;
            text-decoration:none;
            border-radius:6px;
        }
        .product-card .btn:hover { background:#72007a; }
        /* Testimonials */
        .testimonials { padding:50px 20px; text-align:center; background:#ffe6f2; }
        .testimonial-grid { display:flex; flex-wrap:wrap; justify-content:center; gap:30px; }
        .testimonial { background:#fff; padding:20px; border-radius:12px; flex:1 1 250px; box-shadow:0px 4px 10px rgba(0,0,0,0.1); text-align:center; }
        .testimonial img { width:80px; border-radius:50%; margin-bottom:10px; }
        /* About */
        .about { padding:50px 20px; background:#fff0f6; }
        .about-content { display:flex; flex-wrap:wrap; gap:20px; }
        .about-text { flex:1 1 400px; }
        .about-media { flex:1 1 400px; }
        .about-images img { width:100px; border-radius:8px; }
        /* Contact */
        .contact { padding:50px 20px; background:#ffd1dc; text-align:center; }
        .contact-grid { display:flex; flex-wrap:wrap; justify-content:center; gap:40px; }
        .contact-item { background:#fff; padding:20px; border-radius:12px; flex:1 1 200px; box-shadow:0px 4px 10px rgba(0,0,0,0.1); }
        .contact-item i { font-size:40px; color:#6b0f9c; margin-bottom:10px; }
        .contact-item h3 { margin:10px 0 5px; }
        /* Footer */
        footer { padding:20px; text-align:center; background:#6b0f9c; color:#fff; }
    </style>
</head>
<body>

<!-- Navbar -->
<nav>
    <div class="logo">
        <img src="images/flower_logo.png" alt="Flora Logo">
        <span>Flora</span>
    </div>
    <ul>
        <li><a href="index.php"><i class="fas fa-home"></i><span class="hidden-label">Home</span></a></li>
        <li><a href="products.php"><i class="fas fa-th-list"></i><span class="hidden-label">Categories</span></a></li>
        <li><a href="view_more.php"><i class="fas fa-seedling"></i><span class="hidden-label">Products</span></a></li>
        <li><a href="cart_page.php"><i class="fas fa-shopping-cart"></i><span class="hidden-label">Cart</span></a></li>
        <li><a href="checkout.php"><i class="fas fa-credit-card"></i><span class="hidden-label">Checkout</span></a></li>
    </ul>
</nav>

<!-- Hero -->
<header class="hero">
    <div class="overlay">
        <h1>🌸 Fresh Flowers Daily</h1>
        <p>Beautiful flowers delivered from our garden straight to your doorstep</p>
        <a href="products.php" class="shop-btn">🌷 Shop Now</a>
    </div>
</header>

<!-- Flower Products -->
<section class="flower-products">
    <h1>🌷 Our Fresh Flowers</h1>
    <div class="products-grid">
        <?php
        $sql = "SELECT id, name, image, price, description FROM products ORDER BY id DESC";
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                echo '
                <div class="product-card">
                    <img src="images/'.$row['image'].'" alt="'.$row['name'].'">
                    <h3>'.$row['name'].'</h3>
                    <p>'.$row['description'].'</p>
                    <p class="price">LKR '.$row['price'].'</p>
                    <a href="view_more.php?id='.$row['id'].'" class="btn">View Details</a>
                </div>
                ';
            }
        } else {
            echo '<p>No flowers available at the moment. Please check back soon!</p>';
        }
        ?>
    </div>
</section>

<!-- Testimonials -->
<section class="testimonials">
    <h1>💬 What <span>Our Customers</span> Say</h1>
    <div class="testimonial-grid">
        <div class="testimonial">
            <img src="images/customer1.jpg" alt="Anjali">
            <p>"Flora's flowers are always fresh and beautiful! Highly recommend."</p>
            <h4>- Anjali, Colombo</h4>
        </div>
        <div class="testimonial">
            <img src="images/customer2.jpg" alt="Ravi">
            <p>"Quick delivery and stunning bouquets. Perfect for gifts!"</p>
            <h4>- Ravi, Kandy</h4>
        </div>
    </div>
</section>

<!-- About -->
<section class="about">
    <h1 class="text-center mb-4">🌷 <span>About Flora</span></h1>
    <div class="about-content">
        <div class="about-text">
            <p><strong>Flora</strong> is a family-run flower shop delivering fresh and beautiful flowers for every occasion. Our mission is to spread joy and support local growers.</p>
            <ul>
                <li>🌸 <strong>Freshness:</strong> Daily hand-picked flowers.</li>
                <li>💐 <strong>Beautiful Bouquets:</strong> Artfully arranged for every occasion.</li>
                <li>🚚 <strong>Fast Delivery:</strong> Receive flowers within 24 hours.</li>
                <li>🤝 <strong>Support Local:</strong> Collaborating with local growers.</li>
            </ul>
        </div>
        <div class="about-media">
            <div class="about-images">
                <img src="images/flowers1.jpg" alt="Roses">
                <img src="images/flowers2.jpg" alt="Tulips">
                <img src="images/flowers3.jpg" alt="Bouquets">
            </div>
            <video controls class="about-video mt-3" style="border-radius:10px;">
                <source src="videos/flora_intro.mp4" type="video/mp4" />
                Your browser does not support the video tag.
            </video>
        </div>
    </div>
</section>

<!-- Contact -->
<section class="contact">
    <h1>📞 <span>Contact Us</span></h1>
    <div class="contact-grid">
        <div class="contact-item">
            <i class="fas fa-phone"></i>
            <h3>Phone</h3>
            <p>+94 77 123 4567</p>
        </div>
        <div class="contact-item">
            <i class="fas fa-envelope"></i>
            <h3>Email</h3>
            <p>support@flora.com</p>
        </div>
        <div class="contact-item">
            <i class="fas fa-map-marker-alt"></i>
            <h3>Location</h3>
            <p>123 Flower Street, Colombo, Sri Lanka</p>
        </div>
        <div class="contact-item">
            <i class="fas fa-university"></i>
            <h3>Bank Details</h3>
            <p>Bank of Ceylon<br>Account No: 123456789<br>Branch: Colombo</p>
        </div>
    </div>
</section>

<!-- Footer -->
<footer>
    <p>© 2025 Flora | Designed with ❤️</p>
</footer>

</body>
</html>
